<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "config.php";

// Fetch all history
$sql = "SELECT h.id, h.payment_method_id, h.action, h.wallet_name, h.wallet_address, 
               h.payment_type, h.status, h.qr_upload, h.action_date
        FROM payment_methods_history h
        ORDER BY h.action_date DESC";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $history = [];
    while ($row = $result->fetch_assoc()) {
        $history[] = $row;
    }
    echo json_encode([
        "status" => "success",
        "count" => count($history),
        "data" => $history
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "No payment method history found"
    ]);
}

$conn->close();
?>
